############### ###############
## F_H1_A_DM_know_and_inter
## Project: CBO
## Author: Kamil Kouhen
## Date of creation: 23/06/2022
############### ###############

#Uniform Path
path <- here("Output/For Publication/Figures/F_")

  forplot <- DM_finalx2 %>%
    select(A_DM_know_and_inter, respondent_type) %>%
    replace(is.na(.), -999) %>%
    mutate(A_DM_know_and_inter = as.character(A_DM_know_and_inter)) %>%
    mutate(todrop_color = case_when(
      A_DM_know_and_inter == -999 ~ "Missing")) 
  
  ### Duplicating dataset to be able to show respondent and all together
  # in one graph only 
  rbind(forplot, forplot %>% mutate(respondent_type = "All Together")) %>%
    select(A_DM_know_and_inter, respondent_type) %>%
    group_by(respondent_type, A_DM_know_and_inter) %>% 
    summarise(n = n()) %>% 
    mutate(proportion = round((n/ sum(n))*100, digits = 0)) %>%
    ungroup() %>%
    ggplot(aes(y = n, x = respondent_type, fill = A_DM_know_and_inter)) +
    geom_col(position = "dodge")  + 
    scale_x_discrete(labels = c("All\nTogether", "Deputy\nMayor", "Mayor", "Opposition\nMember", "Secretary\nGeneral")) +
    scale_fill_manual(values = c("grey95","grey75","grey65", "grey55", "grey45", "grey35"), 
                      labels = c("Missing",
                                 "Doesn't know the CBO",
                                 "Has heard about the CBO and...",
                                 "...knows at least one member and...", 
                                 "...is aware of the CBO's interactions with municipal institutions...", 
                                 "...has personally been approached by the CBO")) + 
    labs(
      y = "Number of decision makers", 
      x = "Type of decision maker", 
      fill = "Municipal leaders' familiarity with the CBO"
    ) +
    theme_minimal() +
    theme(text = element_text(size=11, family="Times"), 
          legend.title=element_text(size=11), 
          legend.text=element_text(size=8))  +
    theme(plot.margin=grid::unit(c(0,0,0,0), "mm")) 
  
  ggsave(width = 7, height = 4, filename = paste0(path, "H1_", "A_DM_know_and_inter.png"), device = png,  dpi=200)
  
  rm(forplot)  